<?php

namespace SoundView\Bundle\PasswordListBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;

use Oro\Bundle\SoapBundle\Entity\Manager\ApiEntityManager;

use SoundView\Bundle\PasswordListBundle\Entity\Password;

use Oro\Bundle\SecurityBundle\Encoder\Mcrypt;


class PasswordController extends Controller
{
    protected $encryptor;

    /**
     * @Route(
     *      "/{_format}",
     *      name="soundview_password_list_index",
     *      requirements={"_format"="html|json"},
     *      defaults={"_format" = "html"}
     * )
     *
     * @Template
     * @AclAncestor("soundview_password_list_view")
     */
    public function indexAction()
    {
        return [
            'entity_class' => $this->container->getParameter('soundview_password_list.entity.class')
        ];
    }

    /**
     * @Route("/view/{id}", name="soundview_password_list_view", requirements={"id"="\d+"})
     *
     * @Template
     * @Acl(
     *      id="soundview_password_list_view",
     *      type="entity",
     *      permission="VIEW",
     *      class="SoundViewPasswordListBundle:Password"
     * )
     */
    public function viewAction(Password $password)
    {
        $this->setEncryptor();

        return [
            'entity' => $password,
            'passwordPlain' => $this->encryptor->decryptData($password->getPassword())
        ];
    }

    /**
     * @Route("/create", name="soundview_password_list_create")
     * @Acl(
     *      id="soundview_password_list_create",
     *      type="entity",
     *      class="SoundViewPasswordListBundle:Password",
     *      permission="CREATE"
     * )
     * @Template("SoundViewPasswordListBundle:Password:update.html.twig")
     */
    public function createAction()
    {
        $password = new Password();

        return $this->update($password);
    }

    /**
     * Update user form
     * @Route("/update/{id}", name="soundview_password_list_update", requirements={"id"="\d+"})
     *
     * @Template
     * @Acl(
     *      id="soundview_password_list_update",
     *      type="entity",
     *      permission="EDIT",
     *      class="SoundViewPasswordListBundle:Password"
     * )
     */
    public function updateAction(Password $entity)
    {
        return $this->update($entity);
    }

    /**
     * @return ApiEntityManager
     */
    protected function getManager()
    {
        return $this->get('orocrm_contact.contact.manager');
    }

    protected function update(Password $entity = null)
    {
        if (!$entity) {
            $entity = $this->getManager()->createEntity();
        }

        return $this->get('oro_form.model.update_handler')->handleUpdate(
            $entity,
            $this->get('soundview_password_list.form.password'),
            function (Password $entity) {
                return array(
                    'route' => 'soundview_password_list_update',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            function (Password $entity) {
                return array(
                    'route' => 'soundview_password_list_view',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            'Password Saved',
            $this->get('soundview_password_list.form.handler.password')
        );
    }

    protected function setEncryptor()
    {
        $this->encryptor = $this->container->get('oro_security.encoder.mcrypt');
    }

}
