<?php

namespace SoundView\Bundle\SaleBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;

use Oro\Bundle\UserBundle\Entity\User;
use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;
use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;




class SaleController extends Controller
{
    /**
     * @Route(
     *      ".{_format}",
     *      name="svwd_sale_index",
     *      requirements={"_format"="html|json"},
     *      defaults={"_format" = "html"}
     * )
     * @Acl(
     *      id="svwd_sale_view",
     *      type="entity",
     *      class="SoundViewSaleBundle:Sale",
     *      permission="VIEW"
     * )
     * @Template
     */
    public function indexAction()
    {
        return [
            'entity_class' => $this->container->getParameter('svwd_sale.sale.class')
        ];
    }
	
	 /**
     * @Route("/info/{id}", name="svwd_sale_info", requirements={"id"="\d+"})
     *
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function infoAction(Sale $sale)
    {
        $em = $this->getRepository("SoundViewSaleBundle:SoldJob");
        $soldJob = $em->findOneBy(array('soNumber' => $sale->getSoNumber()));
		

        return array(
            'entity'  => $sale,
            'soldJob' => $soldJob
        );
    }
	

    /**
     * @Route("/widget/account-so/{id}", name="svwd_sale_widget_account_sale", requirements={"id"="\d+"})
     * @AclAncestor("svwd_sale_view")
     * @Template
     */
    public function accountSaleAction(Account $account)
    {
        return array('account' => $account);
    }

    /**
     * @Route(
     *         "/widget/account-sale-info/{accountId}",
     *          name="svwd_sale_widget_acount_sale_info",
     *          requirements={"accountId"="\d+"}
     * )
     * @ParamConverter("account", class="OroCRMAccountBundle:Account", options={"id" = "accountId"})
     * @AclAncestor("svwd_sale_view")
     * @Template
     */
    public function accountSalesInfoAction(Account $account)
    {
        $sales = $this->getDoctrine()
            ->getRepository('SoundView\Bundle\SaleBundle\Entity\Sale')
            ->findBy(array(
                'relatedAccount' => $account
                )
            );

        return array('sales' => $sales);
    }
    /**
     * This action is used to render the list of tasks associated with the given entity
     * on the view page of this entity
     *
     * @Route(
     *      "/activity/view/{entityClass}/{entityId}",
     *      name="svwd_sale_activity_view"
     * )
     *
     * @AclAncestor("svwd_sale_view")
     * @Template
     */
    public function activityAction($entityClass, $entityId)
    {
        return array(
            'entity' => $this->get('oro_entity.routing_helper')->getEntity($entityClass, $entityId)
        );
    }

    /**
     * @Route(
     *        "/widget/sale-info/{id}",
     *        name="svwd_sale_widget_sale_info",
     *        requirements={"id"="\d+"}
     * )
     * @AclAncestor("svwd_sale_view")
     * @Template
     */
    public function saleInfoAction(Sale $sale)
    {
        return array('sale' => $sale);
    }

    /**
     * @Route("/create", name="svwd_sale_create")
     * @Acl(
     *      id="svwd_sale_create",
     *      type="entity",
     *      class="SoundViewSaleBundle:Sale",
     *      permission="CREATE"
     * )
     * @Template("SoundViewSaleBundle:Sale:update.html.twig")
     */
    public function createAction()
    {
        $salesOrder = new Sale();


        $accountId = $this->getRequest()->get('accountId');
        if ($accountId) {
            $account = $this->getRepository('OroCRMAccountBundle:Account')->find($accountId);
            if (!$account) {
                throw new NotFoundHttpException(sprintf('Account with ID %s is not found', $accountId));
            }
            $salesOrder->setRelatedAccount($account);
        }

        $contactId = $this->getRequest()->get('contactId');
        if ($contactId) {
            $contact = $this->getRepository('OroCRMContactBundle:Contact')->find($contactId);
            if (!$contact) {
                throw new NotFoundHttpException(sprintf('Contact with ID %s is not found', $contactId));
            }
            $salesOrder->setRelatedContact($contact);
        }

        $assignedToId = $this->getRequest()->get('assignedToId');
        if ($assignedToId) {
            $assignedTo = $this->getRepository('OroUserBundle:User')->find($assignedToId);
            if (!$assignedTo) {
                throw new NotFoundHttpException(sprintf('User with ID %s is not found', $assignedToId));
            }
            $salesOrder->setOwner($assignedTo);
        }


        return $this->update($salesOrder);
    }

    /**
     * @return User
     */
    public function getCurrentUser()
    {
        $token = $this->container->get('security.context')->getToken();

        return $token ? $token->getUser() : null;
    }


    /**
     * @Route("/view/{id}", name="svwd_sale_view", requirements={"id"="\d+"})
     *
     * @Template
     * @Acl(
     *      id="svwd_sale_view",
     *      type="entity",
     *      permission="VIEW",
     *      class="SoundViewSaleBundle:Sale"
     * )
     */
    public function viewAction(Sale $salesOrder)
    {


        return [
            'entity' => $salesOrder
        ];
    }

    /**
     * @Route("/update/{id}", name="svwd_sale_update", requirements={"id"="\d+"})
     * @Template
     * @Acl(
     *      id="svwd_sale_update",
     *      type="entity",
     *      class="SoundViewSaleBundle:Sale",
     *      permission="EDIT"
     * )
     */
    public function updateAction(Sale $salesOrder)
    {
        return $this->update($salesOrder);
    }

    /**
     * @param Sale $entity
     * @return array
     */
    protected function update(Sale $entity = null)
    {
        // $saved = false;
        // $request = $this->getRequest();
        // $form = $this->createForm($this->getFormType(), $salesOrder);

        // if ($request->isMethod('POST')) {
        //     $form->submit($request);
        //     if ($form->isValid()) {
        //         $this->getDoctrine()->getManager()->persist($salesOrder);
        //         $this->getDoctrine()->getManager()->flush();

        //         $saved =  true;

        //         if (!$this->getRequest()->request->has('_widgetContainer')) {
        //             $this->get('session')->getFlashBag()->add(
        //                 'success',
        //                 $this->get('translator')->trans('svwd.sale.saved_message')
        //             );

        //             return $this->get('oro_ui.router')->redirectAfterSave(
        //                 array(
        //                     'route' => 'svwd_sale_update',
        //                     'parameters' => array('id' => $salesOrder->getId()),
        //                 ),
        //                 array(
        //                     'route' => 'svwd_sale_view',
        //                     'parameters' => array('id' => $salesOrder->getId()),
        //                 )
        //             );
        //         }
        //     }
        // }

        // return array(
        //     'saved' => $saved,
        //     'entity' => $salesOrder,
        //     'form' => $form->createView()
        // );

        if (!$entity) {
            $entity = $this->getManager()->createEntity();
        }

        return $this->get('oro_form.model.update_handler')->handleUpdate(
            $entity,
            $this->get('svwd_sale.sale.form'),
            function (Sale $entity) {
                return array(
                    'route' => 'svwd_sale_update',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            function (Sale $entity) {
                return array(
                    'route' => 'svwd_sale_view',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            'Sale Saved',
            $this->get('svwd_sale.sale.form.handler')
        );
    }

    /**
     * @return SaleType
     */
    protected function getFormType()
    {
        return $this->get('svwd_sale.sale.form.type');
    }
	
	    /**
     * @param string $entityName
     * @return \Doctrine\Common\Persistence\ObjectRepository
     */
    protected function getRepository($entityName)
    {
        return $this->getDoctrine()->getRepository($entityName);
    }
	
}
