<?php

namespace SoundView\Bundle\SaleBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;

/**
 * @ORM\Entity
 * @ORM\Table(name="svwd_payment_method")
 */
class PaymentMethod
{
    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=32)
     * @ORM\Id
     */
    protected $name;

    /**
     * @var string
     *
     * @ORM\Column(name="label", type="string", length=255, unique=true)
     */
    protected $label;

    /**
     * @var string
     *
     * @ORM\Column(name="`order`", type="integer")
     */
    protected $order;
	
	
	/**
     * @var float
     *
     * @ORM\Column(name="fee_percent", type="percent", nullable=true)
     */
	protected $fee;

    /**
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
    }

    /**
     * Get Payment method name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
	
	

    /**
     * Set Payment method label
     *
     * @param string $label
     * @return PaymentMethod
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get payment method label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }
	
	    /**
     * Get payment method label
     *
     * @return float
     */
    public function getFee()
    {
        return $this->fee;
    }
	
	

    /**
     * Get order
     *
     * @return integer
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * Set order
     *
     * @param string $order
     * @return PaymentMethod
     */
    public function setOrder($order)
    {
        $this->order = $order;

        return $this;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return (string) $this->label;
    }
}
