<?php

namespace SoundView\Bundle\SaleBundle\Entity;

use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;
use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;

use SoundView\Bundle\SaleBundle\Model\ExtendPurchaseOrder;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;
use Oro\Bundle\ReminderBundle\Entity\RemindableInterface;
use Oro\Bundle\ReminderBundle\Model\ReminderData;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\OrganizationBundle\Entity\Organization;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowItem;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowStep;

use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;
use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\Vendor;






 /**
 * @ORM\Entity
 * @ORM\Table(
 *      name="svwd_purchase_order",
 * )
 * @ORM\Entity(repositoryClass="SoundView\Bundle\SaleBundle\Entity\Repository\PurchaseOrderRepository")
 * @ORM\HasLifecycleCallbacks()
 * @Oro\Loggable
 * @UniqueEntity(
 *     fields="poNumber",
 *     message="Purchase Order already exists."
 * )
  * @Config(
  *      routeName="svwd_po_index",
  *      routeView="svwd_po_view",
  *      defaultValues={
  *          "entity"={
  *              "icon"="icon-money"
  *          },
  *          "ownership"={
  *              "owner_type"="USER",
  *              "owner_field_name"="owner",
  *              "owner_column_name"="owner_id",
  *              "organization_field_name"="organization",
  *              "organization_column_name"="organization_id"
  *          },
  *          "security"={
  *              "type"="ACL",
  *              "group_name"=""
  *          },
  *          "dataaudit"={
  *              "auditable"=true
  *          }
  *      }
  * )
 */
 
 
 
class PurchaseOrder extends ExtendPurchaseOrder implements RemindableInterface
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Soap\ComplexType("int", nillable=true)
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="po_number", type="string", length=255, nullable=false, unique=true)
     * @Soap\ComplexType("string", nillable=true)
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "identity"=true
     *          }
     *      }
     * )
     */
    protected $poNumber;
	
	
	
	
	
	 /**
     * @var Vendor
     *
     * @ORM\ManyToOne(targetEntity="Vendor")
     * @ORM\JoinColumn(name="vendor_name", referencedColumnName="name", onDelete="SET NULL")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $vendor;
	
    /**
     * Items qty
     *
     * @var integer
     *
     * @ORM\Column(name="items_count", type="integer", nullable=true, options={"unsigned"=true})
     */
    protected $itemsCount;

    /**
     * @var Collection
     *
     * @ORM\OneToMany(targetEntity="SoundView\Bundle\SaleBundle\Entity\OrderItemCount",
     *    mappedBy="purchaseOrder", cascade={"all"}, orphanRemoval=true
     * )
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          }
     *      }
     * )
     */
    protected $itemCounts;


	
	 /**
     * @var double
     *
     * @ORM\Column(name="order_amount", type="money", nullable=true)
     */
    protected $orderAmount;
	
	 /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $description;
	
	
	
	 /**
     * @var \DateTime
     *
     * @ORM\Column(name="delivery_eta", type="datetime", nullable=true)
     */
    protected $deliveryEta;
	
	/**
     * @var \DateTime
     *
     * @ORM\Column(name="deliveredOn", type="datetime", nullable=true)
     */
    protected $deliveredOn;
	
	
	 /**
     * @var boolean
     *
     * @ORM\Column(name="is_received", type="boolean", nullable=true)
     * @Soap\ComplexType("boolean", nillable=true)
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "excluded"=true
     *          }
     *      }
     * )
     */
    protected $received = false;

    /**
     * @var PurchaseOrderStatus
     *
     * @ORM\ManyToOne(targetEntity="PurchaseOrderStatus")
     * @ORM\JoinColumn(name="order_status", referencedColumnName="name", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $status;
	
    /**
     * @ORM\ManyToOne(targetEntity="SoundView\Bundle\SaleBundle\Entity\Sale", inversedBy="purchaseOrders")
     * @ORM\JoinColumn(name="sale_id", referencedColumnName="id", onDelete="CASCADE")
     */

    protected $salesOrder;

    /**
     * @var Collection
     *
     * @ORM\OneToMany(targetEntity="SoundView\Bundle\WarehouseBundle\Entity\Inventory",
     *    mappedBy="purchaseOrder", cascade={"all"}, orphanRemoval=true
     * )
     * @ORM\OrderBy({"createdAt" = "ASC"})
     * @Oro\Versioned
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          },
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *      }
     * )
     */

    protected $inventoryLocations;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\UserBundle\Entity\User")
     * @ORM\JoinColumn(name="owner_id", referencedColumnName="id", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $owner;

    /**
     * @var Organization
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\OrganizationBundle\Entity\Organization")
     * @ORM\JoinColumn(name="organization_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *      defaultValues={
     *          "dataaudit"={
     *              "auditable"=true
     *          },
     *          "importexport"={
     *              "order"=190,
     *              "short"=true
     *          },
     *          "reminder"={
     *              "reminder_template_name"="po_reminder",
     *              "reminder_flash_template_identifier"="po_template"
     *          },
     *      }
     * )
     */
    protected $organization;

    /**
     * @var Collection
     */
    protected $reminders;

    /**
     * @var WorkflowItem
     *
     * @ORM\OneToOne(targetEntity="Oro\Bundle\WorkflowBundle\Entity\WorkflowItem")
     * @ORM\JoinColumn(name="workflow_item_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $workflowItem;

    /**
     * @var WorkflowStep
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\WorkflowBundle\Entity\WorkflowStep")
     * @ORM\JoinColumn(name="workflow_step_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $workflowStep;
	
	    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime", nullable=true)
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $updatedAt;
	
	/**
     * @param string|null $poNumber
     */
    public function __construct($poNumber = NULL, $inventoryLocations = NULL)
    {
        parent::__construct();
        $this->poNumber = $poNumber;
        $this->inventoryLocations = new ArrayCollection();
        $this->itemCounts   = new ArrayCollection();
    }

    public function __clone()
    {
        //parent::__clone();

        if ($this->itemCounts) {
            $this->itemCounts = clone $this->itemCounts;
        }

    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set email
     *
     * @param string $poNumber
     * @return SalePO
     */
    public function setPoNumber($poNumber)
    {
        $this->poNumber = $poNumber;

        return $this;
    }

    /**
     * Set itemCounts.
     *
     * This method could not be named setEmails because of bug CRM-253.
     *
     * @param Collection|OrderItemCount[] $itemCounts
     *
     * @return PurchaseOrder
     */
    public function resetItemCounts($itemCounts)
    {
        $this->itemCounts->clear();

        foreach ($itemCounts as $itemCount) {
            $this->addItemCount($itemCount);
        }

        return $this;
    }

    /**
     * Add itemCount
     *
     * @param OrderItemCount $itemCount
     *
     * @return PurchaseOrder
     */
    public function addItemCount(OrderItemCount $itemCount)
    {
        if (!$this->itemCounts->contains($itemCount)) {
            $this->itemCounts->add($itemCount);
            $itemCount->setPurchaseOrder($this);
        }

        return $this;
    }

    /**
     * Remove itemCount
     *
     * @param OrderItemCount $itemCount
     *
     * @return PurchaseOrder
     */
    public function removeItemCount(OrderItemCount $itemCount)
    {
        if ($this->itemCounts->contains($itemCount)) {
            $this->itemCounts->removeElement($itemCount);
        }

        return $this;
    }

    /**
     * Get item counts
     *
     * @return Collection|OrderItemCount[]
     */
    public function getItemCounts()
    {
        return $this->itemCounts;
    }


    /**
     * @param OrderItemCount $itemCount
     * @return bool
     */
    public function hasItemCount(OrderItemCount $itemCount)
    {
        return $this->getItemCounts()->contains($itemCount);
    }

    public function getItemCountString()
    {
        $results = null;
        $i = 0;
        foreach($this->getItemCounts() as $itemCount)
        {
            $i = $i + 1;

            $str = $itemCount->getItemCount();
            $str .= substr($itemCount->getItemType()->getLabel(), 0, 1);
            if($i == 1) {
                $results = $str;
            } else {
                $results .= ', ' . $str;
            }

        }
        return $results;
    }

    /**
     * Get poNumber
     *
     * @return string
     */
    public function getPoNumber()
    {
        return $this->poNumber;
    }
	
	 /**
     * @param float $itemsCount
     *
     * @return $this
     */
    public function setItemsCount($itemsCount)
    {
        $this->itemsCount = $itemsCount;

        return $this;
    }

    /**
     * @return float
     */
    public function getItemsCount()
    {
        return $this->itemsCount;
    }
	
	/**
     * @param Vendor $vendor
     */
    public function setVendor($vendor)
    {
        $this->vendor = $vendor;
    }

    /**
     * @return SaleVendor
     */
    public function getVendor()
    {
        return $this->vendor;
    }
	
	    /**
     * @param string $description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
	
	    /**
     * @param float $ordeAmount
     *
     * @return $this
     */
    public function setOrderAmount($orderAmount)
    {
        $this->orderAmount = $orderAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getOrderAmount()
    {
        return $this->orderAmount;
    }
	
	
    /**
     * Set deliveryEta
     *
     * @param \DateTime $deliveryEta
     * @return Sale
     */
    public function setDeliveryEta($deliveryEta)
    {
        $this->deliveryEta = $deliveryEta;

        return $this;
    }

    /**
     * Get deliveryEta
     *
     * @return \DateTime 
     */
    public function getDeliveryEta()
    {
        return $this->deliveryEta;
    }

	
	    /**
     * Set deliveredOn
     *
     * @param \DateTime $deliveredOn
     * @return Sale
     */
    public function setDeliveredOn($deliveredOn)
    {
        $this->deliveredOn = $deliveredOn;

        return $this;
    }

    /**
     * Get deliveredOn
     *
     * @return \DateTime 
     */
    public function getDeliveredOn()
    {
        return $this->deliveredOn;
    }		
	
	
	/**
     * Set sale as owner.
     *
     * @param Sale $salesOrder
     */
    public function setSalesOrder(Sale $salesOrder = null)
    {
        $this->salesOrder = $salesOrder;
    }

    /**
     * Get owner sale.
     *
     * @return Sale
     */
    public function getSalesOrder()
    {
        return $this->salesOrder;
    }

    public function getStatus()
    {
        return $this->status;
    }

    public function setStatus($status)
    {
        $this->status = $status;
    }
	
	 /**
     * @param bool $received
     * @return SalePO
     */
    public function setReceived($received)
    {
        $this->received = (bool)$received;

        return $this;
    }


    /**
     * @return bool
     */
    public function isReceived()
    {
        return (bool)$this->received;
    }

	public function getUniqLabel() {
		$label = $this->getId() . substr($this->getSalesOrder()->getOwner()->getFirstName(), 0, 1) . substr( $this->getSalesOrder()->getOwner()->getLastName(), 0, 3 );

		return strtoupper($label);
	}

	public function getLabelData(){
		$return = array();

		$return['type'] = $this->getSalesOrder()->getOrderType() ? $this->getSalesOrder()->getOrderType()->getTypeLabel(): 'P';
		$return['po'] = substr($this->getPoNumber(), 0, 10);
		$return['so'] = $this->getSalesOrder()->getSoNumber();
		$return['job'] = substr($this->getSalesOrder()->getJobName(), 0, 50);
		$return['received_on'] = $this->isReceived() ? $this->getDeliveredOn()->format('m/d/Y') : (new \DateTime())->format('m/d/Y');

		return $return;

	}
    
    public function getInventoryLocations()
    {
        return $this->inventoryLocations;
    }

    /**
     * @return string
     */
    public function getWorkflowStepName()
    {
        return $this->getWorkflowStep() ? $this->getWorkflowStep()->getName() : null;
    }

    /**
     * @param WorkflowItem $workflowItem
     */
    public function setWorkflowItem($workflowItem)
    {
        $this->workflowItem = $workflowItem;
    }

    /**
     * @return WorkflowItem
     */
    public function getWorkflowItem()
    {
        return $this->workflowItem;
    }

    /**
     * @param WorkflowItem $workflowStep
     */
    public function setWorkflowStep($workflowStep)
    {
        $this->workflowStep = $workflowStep;
    }

    /**
     * @return WorkflowStep
     */
    public function getWorkflowStep()
    {
        return $this->workflowStep;
    }

    /**
     * @return User
     */
    public function getOwner()
    {
        return $this->owner;
    }

    /**
     * @return mixed|null
     */
    public function getOwnerId()
    {
        return $this->getOwner() ? $this->getOwner()->getId() : null;
    }

    /**
     * @param User $owner
     */
    public function setOwner($owner = null)
    {
        $this->owner = $owner;
    }
    /**
     * Set organization
     *
     * @param Organization $organization
     * @return Sale
     */
    public function setOrganization(Organization $organization = null)
    {
        $this->organization = $organization;

        return $this;
    }

    /**
     * Get organization
     *
     * @return Organization
     */
    public function getOrganization()
    {
        return $this->organization;
    }
	
	
    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * {@inheritdoc}
     */
    public function getReminders()
    {
        return $this->reminders;
    }

    /**
     * {@inheritdoc}
     */
    public function setReminders(Collection $reminders)
    {
        $this->reminders = $reminders;
    }

    /**
     * {@inheritdoc}
     */
    public function getReminderData()
    {
        $result = new ReminderData();

        $result->setSubject($this->getSubject());
        $result->setExpireAt($this->getDueDate());
        $result->setRecipient($this->getOwner());

        return $result;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
	

	/**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }
	
		    /**
     * @return string
     */
    public function __toString()
    {
        $name = $this->getPoNumber();
        $name = preg_replace('/ +/', ' ', $name);

        return (string) trim($name);
    }
}
