<?php

namespace SoundView\Bundle\SaleBundle\Entity\Repository;

use Doctrine\ORM\EntityRepository;

use Doctrine\ORM\QueryBuilder;

use Oro\Bundle\EntityExtendBundle\Tools\ExtendHelper;
/**
 * SaleRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PurchaseOrderRepository extends EntityRepository
{
    /**
     * @param mixed $entityId
     * @param int|null $page
     * @param int|null $limit
     *
     * @return QueryBuilder
     */
    public function getAssociatedPurchaseOrdersQueryBuilder($entityId, $page = null, $limit = null)
    {
        $qb = $this->createQueryBuilder('po')
            ->select('partial po.{id, poNumber, createdAt, updatedAt}')
            ->leftJoin('po.salesOrder', 's')
            ->where('s.id = :entity_id')
            ->setParameter('entity_id', $entityId);

        if (null !== $page) {
            $qb->setFirstResult($this->getOffset($page) * $limit);
        }
        if (null !== $limit) {
            $qb->setMaxResults($limit);
        }

        return $qb;
    }

    /**
     * Get offset by page
     *
     * @param  int|null $page
     * @return int
     */
    protected function getOffset($page)
    {
        if (!$page !== null) {
            $page = $page > 0 ? $page - 1 : 0;
        }

        return $page;
    }
}

