<?php

namespace SoundView\Bundle\SaleBundle\Entity;

use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;
use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;
use Oro\Bundle\ReminderBundle\Entity\RemindableInterface;
use Oro\Bundle\ReminderBundle\Model\ReminderData;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowItem;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowStep;

use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;
use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\Vendor;





 /**
 * @ORM\Entity
 * @ORM\Table(
 *      name="svwd_sold_job_sheet",
 * )
 */
 
 


class SoldJob
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Soap\ComplexType("int", nillable=true)
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="sold_date", type="datetime", nullable=true)
     */
    protected $soldDate;

     /**
     * @var string
     *
     * @ORM\Column(name="name", type="string",length=255, nullable=true)
     */
     protected $name;

    /**
     * @var string
     *
     * @ORM\Column(name="rep", type="string",length=255, nullable=true)
     */
     protected $rep;




    /**
     * @var string
     *
     * @ORM\Column(name="so_number", type="string", length=255, nullable=true)
     */
    protected $soNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="po_number", type="string", length=255, nullable=true)
     */

    protected $poNumber;
    /**
     * @var string
     *
     * @ORM\Column(type="datetime", nullable=true)
     */
    protected $eta;
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=true)
     */
    protected $manufacturer;

            /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */       
    protected $realProductSell;

        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */       
    protected $productSell;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */   
    protected $productCost;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */ 
    protected $productProfit;
        /**
     * @var string
     *
     * @ORM\Column(type="percent", nullable=true)
     */
    protected $productMargin; 
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */
    protected $installSell;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */   
    protected $installCost;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */ 
    protected $installProfit;
        /**
     * @var string
     *
     * @ORM\Column(type="percent", nullable=true)
     */
    protected $installMargin;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */
    protected $totalSell;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */
    protected $totalCost;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */ 
    protected $totalProfit;
        /**
     * @var string
     *
     * @ORM\Column(type="percent", nullable=true)
     */  
    protected $totalMargin;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */  
    protected $firstHalf;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */  
    protected $secondHalf;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */
    protected $totalCommission;    
    /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */    
    protected $totalProfitCommission;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */   
    protected $materialsCost;
        /**
     * @var string
     *
     * @ORM\Column(type="money", nullable=true)
     */ 
    protected $profitOverheadPayroll;
	
	
	/**
     * @param string|null $poNumber
     */
    public function __construct($poNumber = NULL)
    {
        $this->poNumber = $poNumber;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

        /** 
     * @param string $soldDate 
     *
     * @return $this
     */
    public function setSoldDate($soldDate)
    {
        $this->soldDate = $soldDate;

        return $this;
    }

    /**
     * @return string
     */
    public function getSoldDate()
    {
        return $this->soldDate;
    }

                    
    /** 
     * @param string $name 
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

        /** 
     * @param string $name 
     *
     * @return $this
     */
    public function setRep($rep)
    {
        $this->rep = $rep;

        return $this;
    }

    /**
     * @return string
     */
    public function getRep()
    {
        return $this->rep;
    }

                    
    /** 
     * @param string $soNumber 
     *
     * @return $this
     */
    public function setSoNumber($soNumber)
    {
        $this->soNumber = $soNumber;

        return $this;
    }

    /**
     * @return string
     */
    public function getSoNumber()
    {
        return $this->soNumber;
    }

                    
    /** 
     * @param string $poNumber 
     *
     * @return $this
     */
    public function setPoNumber($poNumber)
    {
        $this->poNumber = $poNumber;

        return $this;
    }

    /**
     * @return string
     */
    public function getPoNumber()
    {
        return $this->poNumber;
    }

                    
    /** 
     * @param string $eta 
     *
     * @return $this
     */
    public function setEta($eta)
    {
        $this->eta = $eta;

        return $this;
    }

    /**
     * @return string
     */
    public function getEta()
    {
        return $this->eta;
    }

                    
    /** 
     * @param string $manufacturer 
     *
     * @return $this
     */
    public function setManufacturer($manufacturer)
    {
        $this->manufacturer = $manufacturer;

        return $this;
    }

    /**
     * @return string
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }

              
        /** 
     * @param string $productSell 
     *
     * @return $this
     */
    public function setRealProductSell($realProductSell)
    {
        $this->realProductSell = $realProductSell;

        return $this;
    }

    /**
     * @return string
     */
    public function getRealProductSell()
    {
        return $this->realProductSell;
    }      
    /** 
     * @param string $productSell 
     *
     * @return $this
     */
    public function setProductSell($productSell)
    {
        $this->productSell = $productSell;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductSell()
    {
        return $this->productSell;
    }

                    
    /** 
     * @param string $productCost 
     *
     * @return $this
     */
    public function setProductCost($productCost)
    {
        $this->productCost = $productCost;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductCost()
    {
        return $this->productCost;
    }

                    
    /** 
     * @param string $productProfit 
     *
     * @return $this
     */
    public function setProductProfit($productProfit)
    {
        $this->productProfit = $productProfit;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductProfit()
    {
        return $this->productProfit;
    }

                    
    /** 
     * @param string $productMargin 
     *
     * @return $this
     */
    public function setProductMargin($productMargin)
    {
        $this->productMargin = $productMargin;

        return $this;
    }

    /**
     * @return string
     */
    public function getProductMargin()
    {
        return $this->productMargin;
    }

                    
    /** 
     * @param string $installSell 
     *
     * @return $this
     */
    public function setInstallSell($installSell)
    {
        $this->installSell = $installSell;

        return $this;
    }

    /**
     * @return string
     */
    public function getInstallSell()
    {
        return $this->installSell;
    }

                    
    /** 
     * @param string $installCost 
     *
     * @return $this
     */
    public function setInstallCost($installCost)
    {
        $this->installCost = $installCost;

        return $this;
    }

    /**
     * @return string
     */
    public function getInstallCost()
    {
        return $this->installCost;
    }

                    
    /** 
     * @param string $installProfit 
     *
     * @return $this
     */
    public function setInstallProfit($installProfit)
    {
        $this->installProfit = $installProfit;

        return $this;
    }

    /**
     * @return string
     */
    public function getInstallProfit()
    {
        return $this->installProfit;
    }

                    
    /** 
     * @param string $installMargin 
     *
     * @return $this
     */
    public function setInstallMargin($installMargin)
    {
        $this->installMargin = $installMargin;

        return $this;
    }

    /**
     * @return string
     */
    public function getInstallMargin()
    {
        return $this->installMargin;
    }

                    
    /** 
     * @param string $totalSell 
     *
     * @return $this
     */
    public function setTotalSell($totalSell)
    {
        $this->totalSell = $totalSell;

        return $this;
    }

    /**
     * @return string
     */
    public function getTotalSell()
    {
        return $this->totalSell;
    }

                    
    /** 
     * @param string $totalCost 
     *
     * @return $this
     */
    public function setTotalCost($totalCost)
    {
        $this->totalCost = $totalCost;

        return $this;
    }

    /**
     * @return string
     */
    public function getTotalCost()
    {
        return $this->totalCost;
    }

                    
    /** 
     * @param string $totalProfit 
     *
     * @return $this
     */
    public function setTotalProfit($totalProfit)
    {
        $this->totalProfit = $totalProfit;

        return $this;
    }

    /**
     * @return string
     */
    public function getTotalProfit()
    {
        return $this->totalProfit;
    }

                    
    /** 
     * @param string $totalMargin 
     *
     * @return $this
     */
    public function setTotalMargin($totalMargin)
    {
        $this->totalMargin = $totalMargin;

        return $this;
    }

    /**
     * @return string
     */
    public function getTotalMargin()
    {
        return $this->totalMargin;
    }

                    
    /** 
     * @param string $firstHalf 
     *
     * @return $this
     */
    public function setFirstHalf($firstHalf)
    {
        $this->firstHalf = $firstHalf;

        return $this;
    }

    /**
     * @return string
     */
    public function getFirstHalf()
    {
        return $this->firstHalf;
    }

                    
    /** 
     * @param string $secondHalf 
     *
     * @return $this
     */
    public function setSecondHalf($secondHalf)
    {
        $this->secondHalf = $secondHalf;

        return $this;
    }

    /**
     * @return string
     */
    public function getSecondHalf()
    {
        return $this->secondHalf;
    }

                    
    /** 
     * @param string $totalCommission 
     *
     * @return $this
     */
    public function setTotalCommission($totalCommission)
    {
        $this->totalCommission = $totalCommission;

        return $this;
    }

    /**
     * @return string
     */
    public function getTotalCommission()
    {
        return $this->totalCommission;
    }

                    
    /** 
     * @param string $totalProfitCommission 
     *
     * @return $this
     */
    public function setTotalProfitCommission($totalProfitCommission)
    {
        $this->totalProfitCommission = $totalProfitCommission;

        return $this;
    }

    /**
     * @return string
     */
    public function getTotalProfitCommission()
    {
        return $this->totalProfitCommission;
    }

                    
    /** 
     * @param string $materialsCost 
     *
     * @return $this
     */
    public function setMaterialsCost($materialsCost)
    {
        $this->materialsCost = $materialsCost;

        return $this;
    }

    /**
     * @return string
     */
    public function getMaterialsCost()
    {
        return $this->materialsCost;
    }

                    
    /** 
     * @param string $profitOverheadPayroll 
     *
     * @return $this
     */
    public function setProfitOverheadPayroll($profitOverheadPayroll)
    {
        $this->profitOverheadPayroll = $profitOverheadPayroll;

        return $this;
    }

    /**
     * @return string
     */
    public function getProfitOverheadPayroll()
    {
        return $this->profitOverheadPayroll;
    }

}
