<?php
/**
 * Created by PhpStorm.
 * User: brandon
 * Date: 1/9/15
 * Time: 11:45 AM
 */

namespace SoundView\Bundle\SaleBundle\EventListener;

use Doctrine\ORM\Event\PostFlushEventArgs;

use Symfony\Component\Security\Core\SecurityContextInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\Mapping\ClassMetadata;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Symfony\Bundle\FrameworkBundle\Templating\DelegatingEngine;
use Oro\Bundle\ConfigBundle\Config\ConfigManager;
use Oro\Bundle\EmailBundle\Provider\EmailRenderer;

use Oro\Bundle\UserBundle\Entity\User;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;
use SoundView\Bundle\SaleBundle\Entity\Sale;

class PurchaseOrderListener {
	/**
	 * @var ContainerInterface
	 */
	protected $container;

	/**
	 * @var SecurityContextInterface
	 */
	protected $securityContext;


	/**
	 * @var EntityManager
	 */
	protected $em;

	/**
	 * @var EmailRenderer
	 */

	protected $emailRenderer;


	/**
	 * @var DelegatingEngine
	 */
	protected $templating;

	/**
	 * @var \Swift_Mailer
	 */
	protected $mailer;

	protected $sendNotification = false;
	protected $sendCustomer = false;
	protected $sendTest = false;


	/**
	 * @param ContainerInterface $container
	 */
	public function __construct(
		ContainerInterface $container,
        DelegatingEngine $templating = null,
        \Swift_Mailer $mailer = null,
		EntityManager $em = null,
		EmailRenderer $emailRenderer = null)
	{
		// can't inject security context directly because of circular dependency for Doctrine entity manager
		$this->container = $container;
		$this->templating = $templating;
		$this->mailer     = $mailer;
		$this->em = $em;
		$this->emailRenderer = $emailRenderer;
	}

	public function preUpdate(PreUpdateEventArgs $eventArgs)
	{
		if ($eventArgs->getEntity() instanceof PurchaseOrder) {
			if ($eventArgs->hasChangedField('received') && $eventArgs->getNewValue('received') == true) {
				$this->sendNotification = true;
				if($eventArgs->getEntity()->getSalesOrder()->getOrderType()->getName() == 'customer'){
					$this->sendCustomer = true;
				}
			}
		}
	}

	public function postUpdate(LifecycleEventArgs $args)
	{
		if ($args->getEntity() instanceof PurchaseOrder) {
			if ($this->sendNotification) {
				$this->sendReceivedEmail($args->getEntity());
			}
			if ( $this->sendCustomer ) {
				$this->sendCustomerEmail( $args->getEntity() );
			}
		}
	}

	/**
	 * Send invite email to new user
	 *
	 * @param PurchaseOrder   $entity
	 *
	 * @throws \RuntimeException
	 */
	protected function sendReceivedEmail(PurchaseOrder $entity)
	{

		$this->getMailer();
		$this->getTemplating();

		$senderEmail = 'no-repy@soundviewseattle.com';
		$senderName  = 'Sound View Window & Door';

		$emailTo = $entity->getSalesOrder()->getOwner()->getEmail();
//		$emailTo = 'brandon@soundviewseattle.com';
		


		$subject = sprintf('PO# %s for SO# %s and Account %s Received', $entity->getPoNumber(), $entity->getSalesOrder()->getSoNumber(), $entity->getSalesOrder()->getRelatedAccount());

		if($this->sendTest) {
			$subject .= ' test';
		}

		$message = \Swift_Message::newInstance()
			->setSubject($subject)
			->setFrom($senderEmail, $senderName)
			->setTo($emailTo)
			->setBody(
				$this->templating->render(
					'SoundViewSaleBundle:PurchaseOrder:orderReceived.html.twig',
					['entity' => $entity]
				),
				'text/html'
			);
		$this->mailer->send($message);
	}


	/**
	 * Send invite email to new user
	 *
	 * @param PurchaseOrder $entity
	 *
	 * @throws \RuntimeException
	 */
	protected function sendCustomerEmail( PurchaseOrder $entity ) {

		$this->getMailer();
		$this->getTemplating();
		$this->getEmailRenderer();
		$this->getEntityManager();

		if(!$entity->getSalesOrder()->getRelatedAccount()->getEmail()){
			return;
		}

		$senderEmail = 'no-repy@soundviewseattle.com';
		$senderName  = 'Sound View Window & Door';

//		$em = $this->container->get( 'doctrine.orm.entity_manager' );
		$emailTemplate = $this->em->getRepository( 'Oro\Bundle\EmailBundle\Entity\EmailTemplate' )->find( 11 );


		$emailTo = $entity->getSalesOrder()->getRelatedAccount()->getEmail();
//		$emailTo = 'brandon@soundviewseattle.com';
		list ( $subjectRendered, $templateRendered ) = $this->emailRenderer
		                                                    ->compileMessage( $emailTemplate, [ 'entity' => $entity ] );


		$message = \Swift_Message::newInstance()
		                         ->setSubject( $subjectRendered )
		                         ->setFrom( $senderEmail, $senderName )
		                         ->setTo( $emailTo )
		                         ->setBody(
			                         $templateRendered,
			                         'text/html'
		                         );
		$this->mailer->send( $message );
	}

	protected function getMailer()
	{
		if (!$this->mailer) {
			$this->mailer = $this->container->get('oro_email.direct_mailer');
		}

		return $this->mailer;
	}

	protected function getEntityManager() {
		if ( ! $this->em ) {
			$this->em = $this->container->get( 'doctrine.orm.entity_manager' );
		}

		return $this->em;
	}

	protected function getTemplating()
	{
		if (!$this->templating) {
			$this->templating = $this->container->get('templating');
		}

		return $this->templating;
	}


	protected function getEmailRenderer() {
		if ( ! $this->emailRenderer ) {
			$this->emailRenderer = $this->container->get( 'oro_email.email_renderer' );
		}

		return $this->emailRenderer;
	}

	/**
	 * @return SecurityContextInterface
	 */
	protected function getSecurityContext()
	{
		if (!$this->securityContext) {
			$this->securityContext = $this->container->get('security.context');
		}

		return $this->securityContext;
	}

}