<?php
/**
 * Created by PhpStorm.
 * User: soundview
 * Date: 1/11/16
 * Time: 4:27 PM
 */

namespace SoundView\Bundle\SaleBundle\Provider;

use Oro\Bundle\EntityConfigBundle\Config\ConfigManager;
use Oro\Bundle\EntityConfigBundle\Config\Id\EntityConfigId;
use Oro\Bundle\SearchBundle\Engine\Indexer;
use Oro\Bundle\SearchBundle\Query\Result\Item;
use Oro\Bundle\TranslationBundle\Translation\Translator;

use Oro\Bundle\SearchBundle\Query\Mode;
use Oro\Bundle\SearchBundle\Query\Query;
use Oro\Bundle\SearchBundle\Query\Parser;
use Oro\Bundle\SearchBundle\Query\Result;

class PurchaseOrderResultProvider {
	const TEXT_ALL_DATA_FIELD = 'all_text';
	/**
	 * @var Indexer
	 */
	protected $indexer;

	/**
	 * @var ConfigManager
	 */
	protected $configManager;

	/**
	 * @var Translator
	 */
	protected $translator;

	/**
	 * @param Indexer $indexer
	 * @param ConfigManager $configManager
	 * @param Translator $translator
	 */
	public function __construct( Indexer $indexer, ConfigManager $configManager, Translator $translator ) {
		$this->indexer       = $indexer;
		$this->configManager = $configManager;
		$this->translator    = $translator;
	}


	/**
	 *
	 * @param $query
	 *
	 * @return \Oro\Bundle\SearchBundle\Query\Result
	 */
	public function getResults( $query ) {
		return $this->indexer->simpleSearch( $query );
	}

	/**
	 * Returns grouped search results
	 *
	 * @param string $string
	 * @param string $from
	 *
	 * @return array
	 */

	public function getPurchaseOrders($string){

		$from = "svwd_purchase_order";

		$query = $this->indexer->select();
		$query->from( $from );
		$query->andWhere( 'po_number', Query::OPERATOR_CONTAINS, $string, Query::TYPE_TEXT );


		return $this->indexer->query( $query );

	}


}