<?php
/**
 * Created by PhpStorm.
 * User: soundview
 * Date: 1/21/16
 * Time: 2:35 PM
 */

namespace SoundView\Bundle\SaleBundle\Writer;


use Akeneo\Bundle\BatchBundle\Item\ItemWriterInterface;
use Oro\Bundle\BatchBundle\Item\Support\ClosableInterface;
use Oro\Bundle\ImportExportBundle\Context\ContextAwareInterface;
use Oro\Bundle\ImportExportBundle\Context\ContextInterface;
use Oro\Bundle\ImportExportBundle\Exception\RuntimeException;

use Lyralux\Bundle\PDFBundle\Wrapper\PDF;

abstract class PDFFileStreamWriter implements ItemWriterInterface, ClosableInterface, ContextAwareInterface {
	/**
	 * @var string
	 */
	protected $filePath;
	/**
	 * @var resource
	 */
	protected $fileHandle;
	/**
	 * @var string
	 */
	protected $delimiter = ',';
	/**
	 * @var string
	 */
	protected $enclosure = '"';
	/**
	 * @var bool
	 */
	protected $firstLineIsHeader = true;
	/**
	 * @var array
	 */
	protected $header;

	protected $pdf;

	/**
	 * {@inheritdoc}
	 */


	public function setPdf(){
		if(!$this->pdf) {
			$this->pdf = new PDF();
		}
	}

	public function write( array $items ) {
		// write a header if needed
		if ( ! $this->fileHandle && $this->firstLineIsHeader ) {
			if ( ! $this->header && count( $items ) > 0 ) {
				$this->header = array_keys( $items[0] );
			}
			if ( $this->header ) {
				$this->writeHeader();
			}
		}
		// write items
		foreach ( $items as $item ) {
			$this->writeLine( $item );
		}
		$this->flushOutput();
	}

	/**
	 * Write CSV file header.
	 */
	protected function writeHeader() {
		$this->writeLine( $this->header );
	}

	/**
	 * Write CSV line.
	 *
	 * @param array $fields
	 *
	 * @throws RuntimeException
	 */
	protected function writeLine( array $fields ) {
		$result = $this->pdf->addPage('<h1>TEST</h1>');
//		$result = fputcsv( $this->getFile(), $fields, $this->delimiter, $this->enclosure );
		if ( $result === false ) {
			throw new RuntimeException( 'An error occurred while writing to the csv.' );
		}
	}

	/**
	 * Get file resource.
	 *
	 * @return resource A file pointer resource
	 */
	protected function getFile() {
		if ( ! $this->pdf ) {
			$this->pdf = $this->open();
		}

		return $this->pdf;
	}

	/**
	 * Opens a file.
	 *
	 * @return resource A file pointer resource
	 */
	abstract protected function open();

	/**
	 * Closes an open file.
	 */
	public function close() {
//		if ( $this->fileHandle ) {
//			fclose( $this->fileHandle );
//			$this->fileHandle = null;
//		}
		if ( $this->pdf ) {
			fclose( $this->fileHandle );
			$this->fileHandle = null;
		}
	}

	/**
	 * Flushes the output to a file.
	 */
	protected function flushOutput() {
//		if ( $this->fileHandle ) {
//			fflush( $this->fileHandle );
//		}
		if ( $this->pdf ) {
			$this->pdf->getPdf( $this->fileHandle);
		}
	}

	/**
	 * {@inheritdoc}
	 */
	public function setImportExportContext( ContextInterface $context ) {
		if ( $context->hasOption( 'delimiter' ) ) {
			$this->delimiter = $context->getOption( 'delimiter' );
		}
		if ( $context->hasOption( 'enclosure' ) ) {
			$this->enclosure = $context->getOption( 'enclosure' );
		}
		if ( $context->hasOption( 'firstLineIsHeader' ) ) {
			$this->firstLineIsHeader = (bool) $context->getOption( 'firstLineIsHeader' );
		}
		if ( $context->hasOption( 'header' ) ) {
			$this->header = $context->getOption( 'header' );
		}
	}
}