<?php
namespace SoundView\Bundle\WarehouseBundle\Entity;

use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;
use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;

use SoundView\Bundle\WarehouseBundle\Entity\InventoryLocation;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;
use SoundView\Bundle\SaleBundle\Entity\OrderItemCount;

/**
 * @ORM\Entity
 * @ORM\Table(name="svwd_inventory")
 * @ORM\HasLifecycleCallbacks()
 * @Oro\Loggable
 */

class Inventory {
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;
    
    /**
     * @ORM\ManyToOne(targetEntity="SoundView\Bundle\SaleBundle\Entity\PurchaseOrder", inversedBy="inventoryLocations")
     * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "dataaudit"={"auditable"="true"}
     *  }
     * )
     */

    protected $purchaseOrder;

	/**
	 * @var boolean
	 * @ORM\Column(name="active", type="boolean")
	 *
	 */
	protected $active = 1;
    
    
    
    /**
     * @ORM\ManyToOne(targetEntity="SoundView\Bundle\WarehouseBundle\Entity\InventoryLocation", inversedBy="orders")
     * @ORM\JoinColumn(name="location_id", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $location;
    
    /**
     *
     * @var string
     * 
     * @ORM\Column(name="description", type="string", nullable=true)
     *  
     */
    protected $description;
    
    /**
     *
     * @var string
     * 
     * @ORM\Column(name="items_count", type="integer", nullable=true, options={"unsigned"=true})
     *  
     */
    protected $itemsCount;

    /**
     * @var Collection
     *
     * @ORM\OneToMany(targetEntity="SoundView\Bundle\SaleBundle\Entity\OrderItemCount",
     *    mappedBy="inventory", cascade={"all"}, orphanRemoval=true
     * )
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          }
     *      }
     * )
     */
    protected $itemCounts;
    
    
    
    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime", nullable=true)
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $updatedAt;

    public function __construct()
    {
        $this->itemCounts   = new ArrayCollection();
    }

    public function __clone()
    {


        if ($this->itemCounts) {
            $this->itemCounts = clone $this->itemCounts;
        }

    }
    
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }
    
    /**
     * 
     * @return PurchaseOrder
     */
    
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    
    /**
     * 
     * @param PurchaseOrder $purchaseOrder
     */
    
    public function setPurchaseOrder(PurchaseOrder $purchaseOrder)
    {
        $this->purchaseOrder = $purchaseOrder;
    }
    
    public function getLocation()
    {
        return $this->location;
    }
    
    public function setLocation(InventoryLocation $location)
    {
        $this->location = $location;
    }
    
    /**
     * @param float $itemsCount
     *
     * @return $this
     */
    public function setItemsCount($itemsCount)
    {
        $this->itemsCount = $itemsCount;

        return $this;
    }

    /**
     * @return float
     */
    public function getItemsCount()
    {
        return $this->itemsCount;
    }

    /**
     * Set itemCounts.
     *
     * This method could not be named setEmails because of bug CRM-253.
     *
     * @param Collection|OrderItemCount[] $itemCounts
     *
     * @return PurchaseOrder
     */
    public function resetItemCounts($itemCounts)
    {
        $this->itemCounts->clear();

        foreach ($itemCounts as $itemCount) {
            $this->addItemCount($itemCount);
        }

        return $this;
    }

    /**
     * Add itemCount
     *
     * @param OrderItemCount $itemCount
     *
     * @return PurchaseOrder
     */
    public function addItemCount(OrderItemCount $itemCount)
    {
        if (!$this->itemCounts->contains($itemCount)) {
            $this->itemCounts->add($itemCount);
            $itemCount->setInventory($this);
        }

        return $this;
    }

    /**
     * Remove itemCount
     *
     * @param OrderItemCount $itemCount
     *
     * @return Inventory
     */
    public function removeItemCount(OrderItemCount $itemCount)
    {
        if ($this->itemCounts->contains($itemCount)) {
            $this->itemCounts->removeElement($itemCount);
        }

        return $this;
    }

    /**
     * Get item counts
     *
     * @return Collection|OrderItemCount[]
     */
    public function getItemCounts()
    {
        return $this->itemCounts;
    }


    /**
     * @param OrderItemCount $itemCount
     * @return bool
     */
    public function hasItemCount(OrderItemCount $itemCount)
    {
        return $this->getItemCounts()->contains($itemCount);
    }
    
    public function getDescription()
    {
        return $this->description;
    }
    
    public function setDescription($description)
    {
        $this->description = $description;
    }


	public function setActive($active)
	{
		$this->active = (bool)$active;

		return $this;
	}

	public function getActive()
	{
		return $this->active;
	}

	public function isActive()
	{
		return $this->active;
	}
    
    public function getCreatedAt()
    {
        return $this->createdAt;
    }
    
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }
    
    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }
    
    public function __toString() {
        
        $name = $this->getPurchaseOrder()->getPoNumber();
        $name .= ' - ' . $this->getLocation();
        
        return $name;
    }


    //put your code here
}
