<?php

namespace Oro\Bundle\ImportExportBundle\Writer;

use Oro\Bundle\ImportExportBundle\Context\ContextInterface;

use Slik\DompdfBundle\Wrapper\DompdfWrapper;
/**
 * Writes CSV to PHP output stream
 */
class PdfEchoWriter extends PdfFileStreamWriter
{
    /**
     * Open file.
     *
     * @return resource
     */
    protected function open()
    {
        //return fopen($this->filePath, 'r+');

        return new Response(
            $this->pdf->output(),
            200,
            array(
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename="commissionreport.pdf"'
            )
        );
    }

    /**
     * {@inheritdoc}
     */
    public function setImportExportContext(ContextInterface $context)
    {
        $this->filePath = 'php://output';

        $this->template = 'SvwdCommissionBundle:Commission:Report\paid.html.twig';

        $this->pdf = $this->get('slik_dompdf');

        parent::setImportExportContext($context);
    }
}
