# JavaScript UnitTests

## Installation
For running JS tests following software required:
 - **[Node.js]** (JavaScript Engine)
 - **[Karma]** (Test Runner for JavaScript)
 - **[Jasmine 2.0]** (Behavior-Driven Development Testing Framework)

How to install **Node.js** you can find on [official website](http://nodejs.org/download/). After `node` is installed, you need to install several modules using **[Node Packaged Modules](https://npmjs.org/)** manager:

```bash
npm install -g karma@0.12
npm install -g karma-requirejs@0.2 --save-dev
npm install -g karma-junit-reporter@0.2 --save-dev
npm install -g karma-phantomjs-launcher@0.1 --save-dev
npm install -g karma-chrome-launcher@0.1 --save-dev
npm install -g karma-firefox-launcher@0.1 --save-dev
npm install -g karma-jasmine@0.2 --save-dev
npm install -g karma-coverage@0.2 --save-dev
npm install -g git://github.com/laboro/karma-requirejs-exposure.git --save-dev
```

You can see that in installation command used `-g` flag, means to install modules globally. But you might have a reason to install them locally (into `./node_modules` of current dir), then execute same command without `-g` flag. Just keep in mind, **Karma** module and all plugins have to be installed on same level (all globally or all locally).

## Configuration
Configuration for tests-run is placed in `app/karma.config.ja.dist` (see [documentation](http://karma-runner.github.io/0.10/config/files.html)).

Paths used in configuratin:
- `web/js/require-config.js` main requirejs config (is generated by application durring `oro:requirejs:build`);
- `src/Oro/src/Oro/Bundle/TestFrameworkBundle/Karma/main.js` main entry point of **Karma**;
- `src/*/src/*/Bundle/TestFrameworkBundle/Karma/lib/**/*.js` 3d-party libs required for test, such as [Jasmine-jQuery];
- `src/*/src/*/Bundle/TestFrameworkBundle/Karma/lib/**/require-config.js` configurations for test frameworks;
- `src/*/src/*/Bundle/*Bundle/Tests/JS/Fixture/**/*` fixtures fot test, such as html and json files;
- `web/bundles/**/*.js` all public javascript files (by default are not included in page, due to that we use **RequireJS**);
- `src/*/src/*/Bundle/*Bundle/Tests/JS/**/*Spec.js` tests files (in terms of **Karma** they are specs).

## Running
To run test call command
```bash
karma start app/karma.conf.js.dist --single-run
```
Or if you have **Karma** installed locally:
```bash
./node_modules/.bin/karma start app/karma.conf.js.dist --single-run
```
To run testsuite with custom configuration, you might find useful command line parameters which overwrites parameters in configuration file (see [documentation](http://karma-runner.github.io/0.10/config/files.html)). But usually it's better to create own configuration file, just copy `app/karma.config.js.dist` file to `app/karma.config.js` and modify it.

For developer which use **PHPStorm** will be usefull couple extensions:
- **[Karma](http://plugins.jetbrains.com/plugin/7287)** helps to run testsuite from IDE and see result there; 
- **[ddescriber for jasmine](http://plugins.jetbrains.com/plugin/7233)** helps quickly turn off or skip some tests from testsuite.

## Writing
How to write tests with **Jasmine 2.0** see [documentation](http://jasmine.github.io/2.0/introduction.html).
Here's just trivial case, that's how look spec for `oroui/js/mediator` module:
```js
define(['oroui/js/mediator', 'backbone'],
function(mediator, Backbone) {
    'use strict';

    describe('oroui/js/mediator', function () {
        it("compare mediator to Backbone.Events", function() {
            expect(mediator).toEqual(Backbone.Events);
            expect(mediator).not.toBe(Backbone.Events);
        });
    });
});
```
First, in define section required modules are loaded. And then, inside tree of `describe()` and `it()` calls specified tests assertions.

### karma-requirejs-exposure
This approach allows to test public API of a module. But what about mocking depended on modules and internal module's functional.

Here comes **[karma-requirejs-exposure](https://github.com/laboro/karma-requirejs-exposure.git)** plugin. This **Karma**'s plugin on a fly injects exposing code inside requirejs module and provides API to manipulate internal variables.

See example how it works:
```js
define(['some/module', 'requirejs-exposure'],
function(module, requirejsExposure) {
  'use strict';

  // get exposure instance for tested module
  var exposure = requirejsExposure.disclose('some/module');

  describe('some/module', function () {
    var foo;
    // save original value of foo variable
    exposure.backup('foo');

    beforeEach(function () {
      // create mock object with stub method 'do'
      foo = jasmine.createSpyObj('foo', ['do']);
      // before each test, pass it off instead of original
      exposure.substitute('foo').by(foo);
    });
    afterEach(function () {
        // after each test restore original value of foo
        exposure.recover('foo');
    });

    it('check doSomething() method', function() {
      // private foo object is successfully replaced by the mock
      expect(exposure.retrieve('foo')).toBe(foo);
      // mean time, original object is safe
      expect(exposure.retrieve('foo')).not.toBe(exposure.original('foo'));

      module.doSomething();

      // stub method of mock object has been called
      expect(foo.do).toHaveBeenCalled();
      // this is the same as previous assertion
      expect(exposure.retrieve('foo').do).toHaveBeenCalled();
    });
  });
});
```

### Jasmine-jQuery
[Jasmine-jQuery] extends base functionality of Jasmine:

 - adds bunch of useful matchers, allows to easily check state of a jQuery instance;
 - provides the way for loading HTML and JSON fixtures required for a test;
 - applies HTML-fixtures before each test and rolls back the document after tests.

Due to `Jasmine-jQuery` requires full path to a fixture resource, it's better use `requirejs` to perform loading fixtures by related path.

```js
define(['jquery', 'some/module'], function($, module) {
    var html = require('text!./Fixture/markup.html'),

    describe('some/module', function () {
        beforeEach(function (done) {
            // appends loaded html to document's body,
            // after test rolls back it automatically
            window.setFixtures(html);
        });

        it('checks the markup of a page', function () {
            expect($('li')).toHaveLength(5;
        });
    });
});
```

[Node.js]: <http://nodejs.org/>
[Karma]: <http://karma-runner.github.io/>
[Jasmine 2.0]: <http://jasmine.github.io/2.0/introduction.html>
[Jasmine-jQuery]: <https://github.com/velesin/jasmine-jquery>
